/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.RSSwitchEvent;
import apiipc.generated.events.RSSwitchEventListener;
import apiipc.generated.ui.RSSwitch;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSwitchEventRegistry
extends IPCEventRegistry {
    protected Set<RSSwitchEventListener> globalListeners = new HashSet<RSSwitchEventListener>();
    protected Map<String, Set<RSSwitchEventListener>> specificObjectListeners = new HashMap<String, Set<RSSwitchEventListener>>();

    public RSSwitchEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "RSSwitch";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        RSSwitchEvent.ModeSwitched modeSwitched = null;
        if (!string.equalsIgnoreCase("modeSwitched")) {
            return;
        }
        modeSwitched = new RSSwitchEvent.ModeSwitched(iPCEventLTV);
        for (RSSwitchEventListener object : this.globalListeners) {
            object.handleEvent(modeSwitched);
        }
        Set<RSSwitchEventListener> set = this.specificObjectListeners.get(modeSwitched.objectUUID.toString());
        if (set != null) {
            for (RSSwitchEventListener rSSwitchEventListener : set) {
                rSSwitchEventListener.handleEvent(modeSwitched);
            }
        }
    }

    public void addListenerFiltered(RSSwitchEventListener rSSwitchEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("modeSwitched");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(rSSwitchEventListener);
    }

    public void addSpecificListenerFiltered(RSSwitchEventListener rSSwitchEventListener, RSSwitch rSSwitch, List<String> list) throws IOException {
        UUID uUID = rSSwitch.getObjectUUID();
        String string = uUID.toString();
        Set<RSSwitchEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<RSSwitchEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "modeSwitched");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(rSSwitchEventListener);
    }

    public void removeListenerFiltered(RSSwitchEventListener rSSwitchEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("modeSwitched");
            }
            this.globalListeners.remove(rSSwitchEventListener);
        }
    }

    public void removeSpecificListenerFiltered(RSSwitchEventListener rSSwitchEventListener, RSSwitch rSSwitch, List<String> list) throws IOException {
        UUID uUID = rSSwitch.getObjectUUID();
        String string = uUID.toString();
        Set<RSSwitchEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "modeSwitched");
            set.remove(rSSwitchEventListener);
        }
    }

    public void addListener(RSSwitchEventListener rSSwitchEventListener) throws IOException {
        this.addListenerFiltered(rSSwitchEventListener, null);
    }

    public void addListener(RSSwitchEventListener rSSwitchEventListener, RSSwitch rSSwitch) throws IOException {
        this.addSpecificListenerFiltered(rSSwitchEventListener, rSSwitch, null);
    }

    public void removeListener(RSSwitchEventListener rSSwitchEventListener) throws IOException {
        this.removeListenerFiltered(rSSwitchEventListener, null);
    }

    public void removeListener(RSSwitchEventListener rSSwitchEventListener, RSSwitch rSSwitch) throws IOException {
        this.removeSpecificListenerFiltered(rSSwitchEventListener, rSSwitch, null);
    }
}

